function xoverKids  = crossover(parents, options, NVARS, ...
    FitnessFcn,thisScore,thisPopulation)
%   CROSSOVER_PERMUTATION Crossover function
%
%   The arguments to the function are
%     PARENTS: Parents chosen by the selection function
%     OPTIONS: Options structure created from GAOPTIMSET
%     NVARS: Number of variables
%     FITNESSFCN: Fitness function
%     STATE: State structure used by the GA solver
%     THISSCORE: Vector of scores of the current population
%     THISPOPULATION: Matrix of individuals in the current population

% Matlab retrieves only one child by two parents (divided parents).
nKids = length(parents)/2;
xoverKids = cell(nKids,1); % Normally zeros(nKids,NVARS);

for i=1:2:nKids-1

    % Obtain two parents to crossover
    parent1 = thisPopulation{parents(i)};
    parent2 = thisPopulation{parents(i+1)};

    % Number of sequences in each chromosome
    Nsequences = length(parent1.codification(:,1));

    % Calculate common and different sectors between the two chromosomes
    pos1 = ismember(parent1.codification', parent2.codification', 'rows');
    pos2 = ismember(parent2.codification', parent1.codification', 'rows');

    posSectors = [find(pos1)'; find(pos2)'];
    posSectors = [1 posSectors(1,diff(find(pos1)') > 1) length(parent1.codification);
       1 posSectors(2,diff(find(pos1)') > 1) length(parent2.codification)];
    posSectors = unique(posSectors', 'rows')';

    % Choose which sectors will be changed
    if(length(posSectors) > 1)
        COpos = randi(length(posSectors)-1); 
    else
        COpos = 1;
    end

    % Calculate initial and final positions of the sector
    ini = posSectors(:,COpos);
    fin = posSectors(:,COpos+1);

    % Initialize two new chromosomes
    child1 = parent1;
    child2 = parent2;

    % Find the sectors in both chromosomes
    sector1 = parent1.msa(:,ini(1):fin(1))';
    sector2 = parent2.msa(:,ini(2):fin(2))'; 

    % Crossover of a sector between the chromosomes creating two news.
    % CHROMOSOME 2 -> CHROMOSOME 1 
    if(ini(1) > 1 && fin(1) < length(child1.codification))
        child1.codification = [child1.codification(:, 1:ini(1)-1) parent2.codification(:, ini(2):fin(2)) child1.codification(:, fin(1)+1:length(child1.codification))];
        child1.msa = [child1.msa(:, 1:ini(1)-1) parent2.msa(:, ini(2):fin(2)) child1.msa(:, fin(1)+1:length(child1.msa))];
    elseif(ini(1) == 1)
        child1.codification = [parent2.codification(:, ini(2):fin(2)) child1.codification(:, fin(1)+1:length(child1.codification))];
        child1.msa = [parent2.msa(:, ini(2):fin(2)) child1.msa(:, fin(1)+1:length(child1.msa))];
    elseif(fin(1) == length(child1.codification))
        child1.codification = [child1.codification(:, 1:ini(1)-1) parent2.codification(:, ini(2):fin(2))];
        child1.msa = [child1.msa(:, 1:ini(1)-1) parent2.msa(:, ini(2):fin(2))];
    end

    % CHROMOSOME 1 -> CHROMOSOME 2
    if(ini(2) > 1 && fin(2) < length(child2.codification))
        child2.codification = [child2.codification(:, 1:ini(2)-1) parent1.codification(:, ini(1):fin(1)) child2.codification(:, fin(2)+1:length(child2.codification))];
        child2.msa = [child2.msa(:, 1:ini(2)-1) parent1.msa(:, ini(1):fin(1)) child2.msa(:, fin(2)+1:length(child2.msa))];
    elseif(ini(2) == 1)
        child2.codification = [parent1.codification(:, ini(1):fin(1)) child2.codification(:, fin(2)+1:length(child2.codification))];
        child2.msa = [parent1.msa(:, ini(1):fin(1)) child2.msa(:, fin(2)+1:length(child2.msa))];
    elseif(fin(2) == length(child2.codification))
        child2.codification = [child2.codification(:, 1:ini(2)-1) parent1.codification(:, ini(1):fin(1))];
        child2.msa = [child2.msa(:, 1:ini(2)-1) parent1.msa(:, ini(1):fin(1))];
    end

    % Save in the cell array the new child
    xoverKids{i} = child1;
    xoverKids{i+1} = child2;
end



